VERSION 5.00
Object = "{66677D9B-A7DC-4354-94FC-43B6EB9FE041}#1.1#0"; "VB6Tapi.ocx"
Begin VB.Form frmTAPI 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "VB6Tapi Example"
   ClientHeight    =   8085
   ClientLeft      =   45
   ClientTop       =   435
   ClientWidth     =   6990
   BeginProperty Font 
      Name            =   "Tahoma"
      Size            =   8.25
      Charset         =   177
      Weight          =   400
      Underline       =   0   'False
      Italic          =   0   'False
      Strikethrough   =   0   'False
   EndProperty
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   8085
   ScaleWidth      =   6990
   StartUpPosition =   2  'CenterScreen
   Begin VB.Timer TimerProg 
      Enabled         =   0   'False
      Interval        =   1
      Left            =   4800
      Top             =   5760
   End
   Begin VB.TextBox txtResults 
      BackColor       =   &H00FFFFFF&
      ForeColor       =   &H00000000&
      Height          =   3615
      Left            =   240
      MultiLine       =   -1  'True
      ScrollBars      =   3  'Both
      TabIndex        =   24
      Top             =   4200
      Width           =   6495
   End
   Begin VB.PictureBox Picture1 
      Height          =   0
      Left            =   0
      ScaleHeight     =   0
      ScaleWidth      =   0
      TabIndex        =   23
      Top             =   0
      Width           =   0
   End
   Begin VB.CommandButton cmdMonitorDigit 
      Caption         =   "Monitor Digit"
      Height          =   315
      Left            =   2640
      TabIndex        =   22
      Top             =   1560
      Width           =   1215
   End
   Begin VB.CommandButton cmdDial 
      Caption         =   "Make Call"
      Height          =   315
      Left            =   2640
      TabIndex        =   21
      Top             =   2040
      Width           =   1215
   End
   Begin VB.TextBox txtPhoneNum 
      Height          =   315
      Left            =   480
      TabIndex        =   20
      Top             =   2040
      Width           =   2055
   End
   Begin VB.ComboBox Combo1 
      Height          =   315
      Left            =   480
      Style           =   2  'Dropdown List
      TabIndex        =   19
      Top             =   840
      Width           =   6015
   End
   Begin VB.CommandButton cmdDrop 
      Caption         =   "Drop"
      Height          =   315
      Left            =   1560
      TabIndex        =   18
      Top             =   1560
      Width           =   975
   End
   Begin VB.CommandButton cmdAnswer 
      Caption         =   "Answer"
      Height          =   315
      Left            =   480
      TabIndex        =   17
      Top             =   1560
      Width           =   975
   End
   Begin VB.CommandButton cmdOff 
      Caption         =   "OFF"
      Height          =   315
      Left            =   1560
      TabIndex        =   16
      Top             =   1200
      Width           =   975
   End
   Begin VB.CommandButton cmdOn 
      Caption         =   "ON"
      Height          =   315
      Left            =   480
      TabIndex        =   15
      Top             =   1200
      Width           =   975
   End
   Begin VB.CommandButton cmdLocProp 
      Caption         =   "Local Properties"
      Height          =   315
      Left            =   480
      TabIndex        =   14
      Top             =   480
      Width           =   1455
   End
   Begin VB.CommandButton cmdLocInfo 
      Caption         =   "Local Information"
      Height          =   315
      Left            =   3360
      TabIndex        =   13
      Top             =   480
      Width           =   1575
   End
   Begin VB.CommandButton cmdConfig 
      Caption         =   "Config"
      Height          =   315
      Left            =   5040
      TabIndex        =   12
      Top             =   480
      Width           =   1455
   End
   Begin VB.CommandButton cmdLineInfo 
      Caption         =   "Line Info"
      Height          =   315
      Left            =   2040
      TabIndex        =   11
      Top             =   480
      Width           =   1215
   End
   Begin VB.TextBox txtDigitsToGenerate 
      Height          =   285
      Left            =   3960
      TabIndex        =   10
      Top             =   2040
      Width           =   1215
   End
   Begin VB.CommandButton cmdGenerateDigits 
      Caption         =   "Generate Digits"
      Height          =   315
      Left            =   5280
      TabIndex        =   9
      Top             =   2040
      Width           =   1215
   End
   Begin VB.CommandButton cmdHandOff 
      Caption         =   "Hand Off"
      Height          =   315
      Left            =   3960
      TabIndex        =   8
      Top             =   1560
      Width           =   1215
   End
   Begin VB.CommandButton cmdNumOfPhones 
      Caption         =   "Num Phons"
      Height          =   315
      Left            =   480
      TabIndex        =   7
      Top             =   3240
      Width           =   975
   End
   Begin VB.CommandButton cmdOpenPhone 
      Caption         =   "Open Phone"
      Height          =   315
      Left            =   1560
      TabIndex        =   6
      Top             =   3240
      Width           =   1095
   End
   Begin VB.CommandButton cmdClosePhone 
      Caption         =   "Close Phone"
      Height          =   315
      Left            =   2760
      TabIndex        =   5
      Top             =   3240
      Width           =   1095
   End
   Begin VB.CommandButton cmdPrivilege 
      Caption         =   "Set Privilege"
      Height          =   315
      Left            =   5280
      TabIndex        =   4
      Top             =   1560
      Width           =   1215
   End
   Begin VB.CommandButton cmdID 
      Caption         =   "Get line ID"
      Height          =   315
      Left            =   5280
      TabIndex        =   3
      Top             =   2640
      Width           =   1215
   End
   Begin VB.CommandButton cmdLineUnhold 
      Caption         =   "Unhold"
      Height          =   315
      Left            =   5280
      TabIndex        =   2
      Top             =   1200
      Width           =   1215
   End
   Begin VB.CommandButton cmdHold 
      Caption         =   "Hold"
      Height          =   315
      Left            =   3960
      TabIndex        =   1
      Top             =   1200
      Width           =   1215
   End
   Begin VB.CommandButton cmdSetTerm 
      Caption         =   "Terminal"
      Height          =   315
      Left            =   3960
      TabIndex        =   0
      Top             =   3240
      Width           =   1095
   End
   Begin VB.Frame fraTAPI 
      Caption         =   "TAPI"
      Height          =   3735
      Left            =   240
      TabIndex        =   25
      Top             =   120
      Width           =   6615
      Begin VB.ComboBox cboLineID 
         Height          =   315
         ItemData        =   "frmTAPI.frx":0000
         Left            =   240
         List            =   "frmTAPI.frx":0010
         Style           =   2  'Dropdown List
         TabIndex        =   27
         Top             =   2520
         Width           =   4695
      End
      Begin VB6Tapi.cTapi cTapi1 
         Left            =   5520
         Top             =   2520
         _ExtentX        =   1058
         _ExtentY        =   1058
      End
   End
   Begin VB.Label lblResults 
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "Results:"
      Height          =   195
      Left            =   240
      TabIndex        =   26
      Top             =   3960
      Width           =   585
   End
End
Attribute VB_Name = "frmTAPI"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'VB6 Tapi ActiveX - General example.
'https://www.microncode.com

'VB6 Tapi ActiveX is an OCX control for software
'developers which can handle with phone calls using
'TAPI and modem.

'With this ActiveX you can make phone calls, receive
'phone calls, detect caller-id (caller name and
'caller number), detect digits, generate digits, and
'much more. This ActiveX can be easily integrate
'with WAV Recorder Player ActiveX, so you can record
'phone calls, play sound to the line, pre-screen
'calls (based on the sound card!), detect silence,
'detect voice, and more� fast and easy!

'This ActiveX is full supported with all the
'Voice/Data Modem for windows operation systems.

'This ActiveX can integrate easily with new or existing
'programs, all the functionality was compiled to a one
'OCX file, just drop the control to your form, and
'start to work immediately!

Private Sub cmdAnswer_Click()
    
    'Answer to call
    
    Dim lErr As Long
    
    lErr = cTapi1.LineAnswer()
    
    If lErr < 0 Then
        txtResults.Text = txtResults.Text & Time & ":LineAnswer Error:" & Combo1.List(Combo1.ListIndex) & " (" & cTapi1.GetTapiStrError(lErr) & ")" & vbCrLf
    Else
        txtResults.Text = txtResults.Text & Time & ":LineAnswer:Success." & vbCrLf
    End If

End Sub

Private Sub cmdConfig_Click()
    
    'Display configuration
    
    Dim lErr As Long
    
    lErr = cTapi1.LineConfigDialog(Combo1.ListIndex)
    
    If lErr <> 0 Then
       txtResults = txtResults & cTapi1.GetTapiStrError(lErr) & vbCrLf
    End If

End Sub

Private Sub cmdDial_Click()
    
    'Make a call
    
    Dim lErr As Long
    
    lErr = cTapi1.LineMakeCall(txtPhoneNum.Text)
    
    If lErr > 0 Then
        txtResults.Text = "LineMakeCall to " & txtPhoneNum & "  in:" & Combo1.List(Combo1.ListIndex) & vbCrLf
    Else
        txtResults.Text = txtResults.Text & Time & ":Make a call to : " & txtPhoneNum & " error (" & cTapi1.GetTapiStrError(lErr) & ")" & vbCrLf
    End If

End Sub

Private Sub cmdDrop_Click()
    
    'Drop the call
    
    Dim lErr As Long
    
    lErr = cTapi1.LineDrop()
    
    If lErr > 0 Then
        txtResults.Text = txtResults.Text & Time & ":LineDrop:Success." & vbCrLf
    Else
        txtResults.Text = txtResults.Text & Time & ":LineDrop Error:" & lErr & vbCrLf
    End If

End Sub

Private Sub cmdGenerateDigits_Click()
    
    'Generate digits
    
    Dim lErr As Long
    
    lErr = cTapi1.LineGenerateDigits(txtDigitsToGenerate)
    
    If lErr <> 0 Then
        txtResults.Text = txtResults.Text & Time & ":Generate Digits Error:" & Combo1.List(Combo1.ListIndex) & " (" & cTapi1.GetTapiStrError(lErr) & ")" & vbCrLf
    Else
        txtResults.Text = txtResults.Text & Time & ":Generate Digits " & txtDigitsToGenerate & " is success." & vbCrLf
    End If

End Sub

Private Sub cmdHandOff_Click()

    'Set the application mame to handoff
    
    Dim lErr As Long
    Dim sApplication As String
    
    sApplication = "Your Application.exe"
    
    lErr = cTapi1.LineHandoff(sApplication, LINEMEDIAMODE_INTERACTIVEVOICE)
    
    If lErr <> 0 Then
        txtResults.Text = txtResults.Text & Time & ":LineHandoff Error: " & cTapi1.GetTapiStrError(lErr) & ")" & vbCrLf
    Else
        txtResults.Text = txtResults.Text & Time & ":LineHandoff to " & sApplication & vbCrLf
    End If

End Sub

Private Sub cmdHold_Click()
    
    'Line Hold
    
    'Pleas note:
    'This function may not support a standard
    '56k voice modem (phone device only).
    
    Dim lErr As Long
    
    lErr = cTapi1.lineHold
    
    If lErr <> 0 Then
        txtResults.Text = txtResults.Text & Time & ":LineHold Error:" & cTapi1.GetTapiStrError(lErr) & vbCrLf
    Else
        txtResults.Text = txtResults.Text & Time & ":LineHold:Success." & vbCrLf
    End If

End Sub

Private Sub cmdID_Click()
    
    'Get the line ID
    
    Dim sResults As String
    
    Select Case cboLineID.ListIndex
        Case 0
            'Get the line ID for playing and recording
            sResults = cTapi1.lineGetID(VB6Tapi.DEVICECLASS.WAVEINOUT)
            If sResults > 0 Then
                sResults = "WAVEINOUT: " & sResults
            Else
                sResults = "WAVEINOUT ERROR: " & cTapi1.GetTapiStrError(sResults)
            End If
            
        Case 1
            'Get the line ID for recording
            sResults = cTapi1.lineGetID(VB6Tapi.DEVICECLASS.WAVEIN)
            If sResults > 0 Then
                sResults = "WAVEIN: " & sResults
            Else
                sResults = "WAVEIN ERROR: " & cTapi1.GetTapiStrError(sResults)
            End If
            
        Case 2
            'Get the line ID for playing
            sResults = cTapi1.lineGetID(VB6Tapi.DEVICECLASS.WAVEOUT)
            If sResults > 0 Then
                sResults = "WAVEOUT: " & sResults
            Else
                sResults = "WAVEOUT ERROR: " & cTapi1.GetTapiStrError(sResults)
            End If
            
        Case 3
            'Get the Port ID of the line
            sResults = cTapi1.lineGetID(VB6Tapi.DEVICECLASS.COMMDATA)
            If sResults > 0 Then
                sResults = "COMMDATA: " & sResults
            Else
                sResults = "COMMDATA ERROR: " & cTapi1.GetTapiStrError(sResults)
            End If
            
    End Select
    
    txtResults.Text = txtResults & sResults & vbCrLf

End Sub

Private Sub cmdLineInfo_Click()

    'Get line information
    
    Dim LineDev As LineDevCap
    
    'Set the line index to get the results for:
    cTapi1.LineIndex = Combo1.ListIndex
    
    'Get the device index to the LineDev:
    cTapi1.LineGetDevDetails LineDev
    
    'Display the results:
    txtResults = txtResults & Time & ":" & vbCrLf _
                & "Device Name:" & LineDev.DeviceName & vbCrLf _
                & "Tapi Capability: " & LineDev.TapiCapability & vbCrLf _
                & "Max Rate: " & LineDev.MaxRate & vbCrLf _
                & "Support Monitor Digits: " & LineDev.MonitorDigits & vbCrLf _
                & "Support Generate Digits: " & LineDev.GenerateDigits & vbCrLf _
                & "Data Mode:" & LineDev.MediaDatamodem & vbCrLf _
                & "Interactivevoice:" & LineDev.MediaInteractivevoice & vbCrLf _
                & "Auto Voice:" & LineDev.MediaAutomatedvoice & vbCrLf _
                & "IsOpened:" & cTapi1.IsLineOpen & vbCrLf _
                & "IsConnected:" & cTapi1.LineIsConnected & vbCrLf
    
                txtResults = txtResults & vbCrLf
            
End Sub

Private Sub cmdLineUnhold_Click()

    'Line Unhole
    
    'Pleas note:
    'This function may not support a standard
    '56k voice modem (phone device only).
    
    Dim lErr As Long
    
    lErr = cTapi1.lineUnhold
    
    If lErr <> 0 Then
        txtResults.Text = txtResults.Text & Time & ":LineUnhold Error: " & cTapi1.GetTapiStrError(lErr) & vbCrLf
    Else
        txtResults.Text = txtResults.Text & Time & ":LineUnhold:Success." & vbCrLf
    End If

End Sub

Private Sub cmdLocInfo_Click()

    'Get the country code:
    txtResults.Text = txtResults & "Local country Code:" & cTapi1.GetCountryCode & vbCrLf
    
    'Get the city code:
    txtResults.Text = txtResults & "Local city Code:" & cTapi1.GetCityCode & vbCrLf

End Sub

Private Sub cmdLocProp_Click()

    cTapi1.LineTranslateDialog

End Sub

Private Sub cmdMonitorDigit_Click()

    'Monitor digits (to the MonitorDigit event)
    
    Dim lErr As Long
    
    lErr = cTapi1.LineMonitorDigits(True)
    
    If lErr <> 0 Then
        txtResults.Text = txtResults.Text & Time & ":LineMonitorDigits Error: " & cTapi1.GetTapiStrError(lErr) & vbCrLf
    Else
        txtResults.Text = txtResults.Text & Time & ":LineMonitorDigits:Success." & vbCrLf
    End If

End Sub

Private Sub cmdNumOfPhones_Click()

    'Number of installed phone devices
    
    'Pleas note:
    'This function may not support a standard
    '56k voice modem (phone device only).
    
    Call cTapi1.PhoneInitialize
    MsgBox "There is: " & cTapi1.NumOfPhones & " installed phone devices on this machine", vbInformation

End Sub

Private Sub cmdOff_Click()

    'Close the line
    
    Dim lErr As Long
    
    lErr = cTapi1.LineClose()
    
    If lErr <> 0 Then
        txtResults.Text = txtResults.Text & Time & ":LineClose Error:" & Combo1.List(Combo1.ListIndex) & " (" & cTapi1.GetTapiStrError(lErr) & ")" & vbCrLf
    Else
       txtResults.Text = txtResults.Text & Time & ":Close " & Combo1.List(Combo1.ListIndex) & " is success." & vbCrLf
    End If
    
    'Shutdown the line
    lErr = cTapi1.LineShutdown()
    If lErr <> 0 Then
        txtResults.Text = txtResults.Text & Time & ":LineShutdown Error:" & Combo1.List(Combo1.ListIndex) & " (" & cTapi1.GetTapiStrError(lErr) & ")" & vbCrLf
    Else
       txtResults.Text = txtResults.Text & Time & ":Shutdown " & Combo1.List(Combo1.ListIndex) & " is success." & vbCrLf
    End If

End Sub

Private Sub cmdOn_Click()
    
        'Open the line
        
        Dim lErr As Long
    
        'Set the line index:
        cTapi1.LineIndex = Combo1.ListIndex
    
        'Open the line for in/out calls:
        lErr = cTapi1.LineOpen(LINECALLPRIVILEGE_OWNER _
        , LINEMEDIAMODE_DATAMODEM)
        
        'For a data modem (not a voice modem):
        'lErr = cTapi1.LineOpen(LINECALLPRIVILEGE_OWNER _
        , LINEMEDIAMODE_AUTOMATEDVOICE)
        
        'Check the results:
        If lErr <> 0 Then
            txtResults.Text = txtResults.Text & Time & ":Error open:" & Combo1.List(Combo1.ListIndex) & " (" & cTapi1.GetTapiStrError(lErr) & ") Try to open with LINEMEDIAMODE_DATAMODEM parameter." & vbCrLf
        Else
            txtResults.Text = txtResults.Text & Time & ":LineOpen " & Combo1.List(Combo1.ListIndex) & " success." & vbCrLf
        End If

End Sub

Private Sub cmdOpenPhone_Click()

    'Open the phone device
    
    'Pleas note:
    'This function may not support a standard
    '56k voice modem (phone device only).
    
    Dim lErr As Long
    
    'Set the phone device index:
    cTapi1.PhoneIndex = Combo1.ListIndex
    
    'Open the phone device:
    lErr = cTapi1.PhoneOpen()
    
    If lErr <> 0 Then
        txtResults.Text = txtResults.Text & Time & ":Cannot open " & Combo1.List(Combo1.ListIndex) & " as a phone device(" & cTapi1.GetTapiStrError(lErr) & ")" & vbCrLf
    Else
        txtResults.Text = txtResults.Text & Time & ":Open " & Combo1.List(Combo1.ListIndex) & " as a phone device success." & vbCrLf
    End If

End Sub

Private Sub cmdClosePhone_Click()

    'Close the phone device
    
    'Pleas note:
    'This function may not support a standard
    '56k voice modem (phone device only).
    
    Dim lErr As Long
    
    'Close the phone device:
    lErr = cTapi1.PhoneShutdown
    
    If lErr <> 0 Then
        txtResults.Text = txtResults.Text & cTapi1.GetTapiStrError(lErr) & vbCrLf
    Else
        txtResults.Text = txtResults.Text & Time & ":Close " & Combo1.List(Combo1.ListIndex) & " as a phone device" & vbCrLf
    End If

End Sub

Private Sub cmdSetTerm_Click()

    Dim lErr As Long
    
    lErr = cTapi1.PhoneSetHookSwitch(PHONEHOOKSWITCHDEV_SPEAKER, PHONEHOOKSWITCHMODE_MICSPEAKER)
    
    If lErr <> 0 Then
        txtResults.Text = txtResults.Text & Time & ":Error PhoneSetHookSwitch:" & cTapi1.GetTapiStrError(lErr) & vbCrLf
    Else
        txtResults.Text = txtResults.Text & Time & ":PhoneSetHookSwitch " & Combo1.List(Combo1.ListIndex) & vbCrLf
    End If

End Sub

Private Sub cmdPrivilege_Click()
    
    Dim rc As Long
    
    'Set the call privilege:
    rc = cTapi1.LineSetCallPrivilege(LINECALLPRIVILEGE_OWNER)
    If rc <> 0 Then
        txtResults.Text = txtResults.Text & cTapi1.GetTapiStrError(rc) & vbCrLf
    Else
        txtResults.Text = txtResults.Text & Time & ":LineSetPrivilege: " & cTapi1.GetTapiStrError(rc) & vbCrLf
    End If

End Sub

Private Sub Form_Load()
    
    On Error Resume Next
    
    Dim LineIndex As Long
    Dim sDeviceName As String
    Dim LineDev As LineDevCap
    Dim lErr As Long
    
    'Init the control, must be call
    'before using any functionality
    'of the control.
    '
    'sKey = Your license key.
    '
    cTapi1.Init "Trial Mode."
    
    'First, init the TAPI environment:
    lErr = cTapi1.LineInitialize
    If lErr <> 0 Then
        MsgBox "Cannot Init Tapi:" & cTapi1.GetTapiStrError(lErr)
        Exit Sub
    End If
        
    'Set default values:
    cboLineID.ListIndex = 0
    
    'Scan all the lines and get the device name:
    For LineIndex = 0 To cTapi1.NumOfLines - 1
        
        'Get device details by the index
        cTapi1.LineIndex = LineIndex
        cTapi1.LineGetDevDetails LineDev
        sDeviceName = LineDev.DeviceName
        
        'Add to the list DeviceName and DeviceIndex.
        Combo1.AddItem sDeviceName
        
    Next LineIndex
    
    'Select the first device:
    Combo1.ListIndex = 0

End Sub

Private Sub Form_Unload(Cancel As Integer)
    
    'Check if the line is open:
    If cTapi1.IsLineOpen Then cTapi1.LineShutdown
    
    'Check if the phone device is open:
    If cTapi1.IsPhoneOpen Then cTapi1.PhoneShutdown
    
    'Release the control:
    cTapi1.DeInit

End Sub

Private Sub txtResults_Change()
    
    On Error Resume Next
    
    txtResults.SelStart = Len(txtResults.Text) - 1

End Sub

'*************************************************************
'TAPI Events
'*************************************************************
Private Sub cTapi1_CallerID(ByVal CallerName As String, ByVal CallerNumber As String)

    txtResults = txtResults & "Caller name:" & CallerName & " Caller number:" & CallerNumber & " in line index: " & cTapi1.LineIndex & vbCrLf

End Sub

Private Sub cTapi1_Connected()

    txtResults = txtResults & "The call in line index:" & cTapi1.LineIndex & " is connected" & vbCrLf

End Sub

Private Sub cTapi1_Dialing()

    txtResults = txtResults & "Dialing '" & txtPhoneNum & "' in line index:" & cTapi1.LineIndex & vbCrLf

End Sub

Private Sub cTapi1_Disconnected()

    txtResults = txtResults & "Disconnected call in line index:" & cTapi1.LineIndex & vbCrLf

End Sub

Private Sub cTapi1_DoneGenerateDigits()

    txtResults = txtResults & "Done generate the '" & txtDigitsToGenerate & "' digits in line index" & cTapi1.LineIndex & vbCrLf

End Sub

Private Sub cTapi1_Idle()

    txtResults = txtResults & "Idel call in line index:" & cTapi1.LineIndex & vbCrLf

End Sub

Private Sub cTapi1_IncomingCall()

    txtResults = txtResults & "Incoming call in line index:" & cTapi1.LineIndex & vbCrLf

End Sub

Private Sub cTapi1_MonitorDigit(ByVal Digit As String)

    txtResults = txtResults & "Digit:" & Digit & " Line index:" & cTapi1.LineIndex & vbCrLf

End Sub

Private Sub cTapi1_ProcNumber(ByVal ProcNumber As Long, ByVal ResultNumber As Long)
'Raise when an asynchronous function returns a value

    txtResults = txtResults & cTapi1.LineIndex & " From process number" & ProcNumber & ResultNumber & vbCrLf

End Sub

Private Sub cTapi1_Ring(ByVal RingNumber As Long)

    txtResults = txtResults & "Ring:" & RingNumber & "  Line index:" & cTapi1.LineIndex & vbCrLf

End Sub

