VERSION 5.00
Object = "{831FDD16-0C5C-11D2-A9FC-0000F8754DA1}#2.0#0"; "MSCOMCTL.OCX"
Object = "{66677D9B-A7DC-4354-94FC-43B6EB9FE041}#1.1#0"; "VB6Tapi.ocx"
Begin VB.Form frmTAPIAudio 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "TAPI Modem ActiveX - General TAPI with Audio sample."
   ClientHeight    =   11550
   ClientLeft      =   45
   ClientTop       =   435
   ClientWidth     =   7185
   BeginProperty Font 
      Name            =   "Tahoma"
      Size            =   8.25
      Charset         =   177
      Weight          =   400
      Underline       =   0   'False
      Italic          =   0   'False
      Strikethrough   =   0   'False
   EndProperty
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   11550
   ScaleWidth      =   7185
   StartUpPosition =   2  'CenterScreen
   Begin VB.Timer tmSlider 
      Enabled         =   0   'False
      Interval        =   100
      Left            =   5400
      Top             =   6000
   End
   Begin VB.TextBox txtAudioFile 
      Height          =   915
      Left            =   480
      MultiLine       =   -1  'True
      TabIndex        =   39
      Text            =   "frmTAPIAudio.frx":0000
      Top             =   4200
      Width           =   6015
   End
   Begin VB6Tapi.cTapi cTapi1 
      Left            =   6240
      Top             =   2520
      _ExtentX        =   1058
      _ExtentY        =   1058
   End
   Begin VB.PictureBox picTimeHolder 
      BorderStyle     =   0  'None
      Height          =   375
      Left            =   480
      ScaleHeight     =   375
      ScaleWidth      =   2055
      TabIndex        =   35
      Top             =   6720
      Width           =   2055
      Begin VB.Label lblCurrentPositionSec 
         AutoSize        =   -1  'True
         BackStyle       =   0  'Transparent
         Caption         =   "0:00:00"
         BeginProperty Font 
            Name            =   "Tahoma"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         ForeColor       =   &H00000000&
         Height          =   195
         Left            =   240
         TabIndex        =   37
         Top             =   120
         Width           =   570
      End
      Begin VB.Label lbTotalLengthSec 
         AutoSize        =   -1  'True
         BackStyle       =   0  'Transparent
         Caption         =   "0:00:00"
         BeginProperty Font 
            Name            =   "Tahoma"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         ForeColor       =   &H00000000&
         Height          =   195
         Left            =   1200
         TabIndex        =   36
         Top             =   120
         Width           =   570
      End
   End
   Begin VB.CommandButton cmdPauseOut 
      Caption         =   "Pause Play"
      Height          =   375
      Left            =   2640
      Style           =   1  'Graphical
      TabIndex        =   33
      Top             =   6360
      Width           =   1335
   End
   Begin VB.CommandButton cmdUnPauseOut 
      Caption         =   "Unpause Play"
      Height          =   375
      Left            =   4080
      Style           =   1  'Graphical
      TabIndex        =   32
      Top             =   6360
      Width           =   1335
   End
   Begin VB.CommandButton cmdPlay 
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   177
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   600
      MaskColor       =   &H00FFFFFF&
      Picture         =   "frmTAPIAudio.frx":000E
      Style           =   1  'Graphical
      TabIndex        =   31
      ToolTipText     =   "Play"
      Top             =   6360
      UseMaskColor    =   -1  'True
      Width           =   855
   End
   Begin VB.CommandButton cmdStop 
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   177
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   1560
      MaskColor       =   &H00FFFFFF&
      Picture         =   "frmTAPIAudio.frx":062C
      Style           =   1  'Graphical
      TabIndex        =   30
      ToolTipText     =   "Stop"
      Top             =   6360
      UseMaskColor    =   -1  'True
      Width           =   855
   End
   Begin MSComctlLib.ProgressBar prgMeter 
      Height          =   255
      Left            =   600
      TabIndex        =   29
      Top             =   5520
      Width           =   6015
      _ExtentX        =   10610
      _ExtentY        =   450
      _Version        =   393216
      Appearance      =   1
      Max             =   120
   End
   Begin VB.CheckBox chkCutSilence 
      Caption         =   "Cut the silence section from the end of recorded audio file"
      Height          =   255
      Left            =   480
      TabIndex        =   28
      Top             =   3840
      Width           =   4695
   End
   Begin VB.CheckBox chkMeterIn 
      Caption         =   "Display meter"
      Height          =   255
      Left            =   480
      TabIndex        =   27
      Top             =   3120
      Value           =   1  'Checked
      Width           =   5895
   End
   Begin VB.CommandButton cmdUnPauseIn 
      Caption         =   "Unpause Record"
      Height          =   375
      Left            =   4080
      Style           =   1  'Graphical
      TabIndex        =   26
      Top             =   5160
      Width           =   1335
   End
   Begin VB.CommandButton cmdPauseIn 
      Caption         =   "Pause Record"
      Height          =   375
      Left            =   2640
      Style           =   1  'Graphical
      TabIndex        =   25
      Top             =   5160
      Width           =   1335
   End
   Begin VB.CheckBox chkPreScreen 
      Caption         =   "Play the recorded audio buffers to a diferent sound device (for pre-screen)"
      Height          =   255
      Left            =   480
      TabIndex        =   24
      Top             =   3480
      Value           =   1  'Checked
      Width           =   6255
   End
   Begin VB.CommandButton cmdRecord 
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   177
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   600
      MaskColor       =   &H00FFFFFF&
      Picture         =   "frmTAPIAudio.frx":0C4A
      Style           =   1  'Graphical
      TabIndex        =   23
      ToolTipText     =   "Record"
      Top             =   5160
      UseMaskColor    =   -1  'True
      Width           =   855
   End
   Begin VB.CommandButton cmdStopRec 
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   177
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   1560
      MaskColor       =   &H00FFFFFF&
      Picture         =   "frmTAPIAudio.frx":1224
      Style           =   1  'Graphical
      TabIndex        =   22
      ToolTipText     =   "Stop"
      Top             =   5160
      UseMaskColor    =   -1  'True
      Width           =   855
   End
   Begin VB.TextBox txtResults 
      BackColor       =   &H00FFFFFF&
      ForeColor       =   &H00000000&
      Height          =   3375
      Left            =   240
      MultiLine       =   -1  'True
      ScrollBars      =   3  'Both
      TabIndex        =   19
      Top             =   7800
      Width           =   6495
   End
   Begin VB.PictureBox Picture1 
      Height          =   0
      Left            =   0
      ScaleHeight     =   0
      ScaleWidth      =   0
      TabIndex        =   18
      Top             =   0
      Width           =   0
   End
   Begin VB.CommandButton cmdMonitorDigit 
      Caption         =   "Monitor Digit"
      Height          =   315
      Left            =   2640
      TabIndex        =   17
      Top             =   1560
      Width           =   1215
   End
   Begin VB.CommandButton cmdDial 
      Caption         =   "Make Call"
      Height          =   315
      Left            =   5040
      TabIndex        =   16
      Top             =   1200
      Width           =   1455
   End
   Begin VB.TextBox txtPhoneNum 
      Height          =   315
      Left            =   2640
      TabIndex        =   15
      Top             =   1200
      Width           =   2295
   End
   Begin VB.ComboBox Combo1 
      Height          =   315
      Left            =   480
      Style           =   2  'Dropdown List
      TabIndex        =   14
      Top             =   840
      Width           =   6015
   End
   Begin VB.CommandButton cmdDrop 
      Caption         =   "Drop"
      Height          =   315
      Left            =   1560
      TabIndex        =   13
      Top             =   1560
      Width           =   975
   End
   Begin VB.CommandButton cmdAnswer 
      Caption         =   "Answer"
      Height          =   315
      Left            =   480
      TabIndex        =   12
      Top             =   1560
      Width           =   975
   End
   Begin VB.CommandButton cmdOff 
      Caption         =   "OFF"
      Height          =   315
      Left            =   1560
      TabIndex        =   11
      Top             =   1200
      Width           =   975
   End
   Begin VB.CommandButton cmdOn 
      Caption         =   "ON"
      Height          =   315
      Left            =   480
      TabIndex        =   10
      Top             =   1200
      Width           =   975
   End
   Begin VB.CommandButton cmdLocProp 
      Caption         =   "Local Properties"
      Height          =   315
      Left            =   480
      TabIndex        =   9
      Top             =   480
      Width           =   1455
   End
   Begin VB.CommandButton cmdLocInfo 
      Caption         =   "Local Information"
      Height          =   315
      Left            =   3360
      TabIndex        =   8
      Top             =   480
      Width           =   1575
   End
   Begin VB.CommandButton cmdConfig 
      Caption         =   "Config"
      Height          =   315
      Left            =   5040
      TabIndex        =   7
      Top             =   480
      Width           =   1455
   End
   Begin VB.CommandButton cmdLineInfo 
      Caption         =   "Line Info"
      Height          =   315
      Left            =   2040
      TabIndex        =   6
      Top             =   480
      Width           =   1215
   End
   Begin VB.TextBox txtDigitsToGenerate 
      Height          =   285
      Left            =   3960
      TabIndex        =   5
      Top             =   1560
      Width           =   975
   End
   Begin VB.CommandButton cmdGenerateDigits 
      Caption         =   "Generate Digits"
      Height          =   315
      Left            =   5040
      TabIndex        =   4
      Top             =   1560
      Width           =   1455
   End
   Begin VB.CommandButton cmdNumOfPhones 
      Caption         =   "Num Phons"
      Height          =   315
      Left            =   480
      TabIndex        =   3
      Top             =   2040
      Width           =   975
   End
   Begin VB.CommandButton cmdOpenPhone 
      Caption         =   "Open Phone"
      Height          =   435
      Left            =   1560
      TabIndex        =   2
      Top             =   2040
      Width           =   975
   End
   Begin VB.CommandButton cmdClosePhone 
      Caption         =   "Close Phone"
      Height          =   435
      Left            =   2640
      TabIndex        =   1
      Top             =   2040
      Width           =   1215
   End
   Begin VB.CommandButton cmdSetTerm 
      Caption         =   "Terminal"
      Height          =   315
      Left            =   3960
      TabIndex        =   0
      Top             =   2040
      Width           =   975
   End
   Begin VB.Frame fraTAPI 
      Caption         =   "TAPI"
      Height          =   2535
      Left            =   240
      TabIndex        =   20
      Top             =   120
      Width           =   6615
      Begin VB6Tapi.cWave cWave1 
         Left            =   6000
         Top             =   1800
         _ExtentX        =   1058
         _ExtentY        =   1058
      End
   End
   Begin MSComctlLib.Slider cSlider1 
      Height          =   375
      Left            =   480
      TabIndex        =   34
      Top             =   5880
      Width           =   6135
      _ExtentX        =   10821
      _ExtentY        =   661
      _Version        =   393216
      Max             =   100
   End
   Begin VB.Frame froAudio 
      Caption         =   "Audio"
      Height          =   4455
      Left            =   240
      TabIndex        =   38
      Top             =   2760
      Width           =   6615
      Begin VB.CommandButton cmdFileDetails 
         Caption         =   "File Details"
         Height          =   375
         Left            =   5040
         Style           =   1  'Graphical
         TabIndex        =   40
         Top             =   1080
         Width           =   1215
      End
   End
   Begin VB.Label lblResults 
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "Results:"
      Height          =   195
      Left            =   360
      TabIndex        =   21
      Top             =   7440
      Width           =   585
   End
End
Attribute VB_Name = "frmTAPIAudio"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'VB6 TAPI ActiveX - General TAPI with Audio example.
'https://www.microncode.com

'This sample demonstrate how to use the VB6 TAPI ActiveX
'with WAV Player and Recorder ActiveX.
'This allows you develop many types of phone application for
'Windows, such as: anwering machine.

Option Explicit

Dim WaveFormat_PCM As WaveFormat

Private Sub chkMeterIn_Click()

    'Open the meter display
    
    If chkMeterIn.Value = 1 Then
        cWave1.MeterIn = True
        txtResults.Text = txtResults.Text & Time & ": MeterIn=True." & vbCrLf
    Else
        cWave1.MeterIn = False
        txtResults.Text = txtResults.Text & Time & ": MeterIn=False." & vbCrLf
    End If

End Sub

Private Sub chkPreScreen_Click()

    'Open the pres screen
    
    If chkPreScreen.Value = 1 Then
        cWave1.PreScreenOpen WaveFormat_PCM, 0
        txtResults.Text = txtResults.Text & Time & ": PreScreenOpen." & vbCrLf
    Else
       cWave1.PreScreenClose
       txtResults.Text = txtResults.Text & Time & ": PreScreenClose." & vbCrLf
    End If

End Sub

Private Sub cmdAnswer_Click()
    
    'Answer to call
    
    Dim lErr As Long
    
    lErr = cTapi1.LineAnswer()
    
    If lErr < 0 Then
        txtResults.Text = txtResults.Text & Time & ":LineAnswer Error:" & Combo1.List(Combo1.ListIndex) & " (" & cTapi1.GetTapiStrError(lErr) & ")" & vbCrLf
    Else
        txtResults.Text = txtResults.Text & Time & ":LineAnswer:Success." & vbCrLf
    End If

End Sub

Private Sub cmdConfig_Click()

    'Display configuration:
    
    Dim lErr As Long
    
    lErr = cTapi1.LineConfigDialog(Combo1.ListIndex)
    If lErr <> 0 Then
       txtResults = txtResults & cTapi1.GetTapiStrError(lErr) & vbCrLf
    End If

End Sub

Private Sub cmdDial_Click()

    'Make a call
    
    Dim lErr As Long
    
    lErr = cTapi1.LineMakeCall(txtPhoneNum.Text)
    
    If lErr > 0 Then
        txtResults.Text = "LineMakeCall to " & txtPhoneNum & "  in:" & Combo1.List(Combo1.ListIndex) & vbCrLf
    Else
        txtResults.Text = txtResults.Text & Time & ":Make a call to : " & txtPhoneNum & " error (" & cTapi1.GetTapiStrError(lErr) & ")" & vbCrLf
    End If

End Sub

Private Sub cmdDrop_Click()

    'Drop the call:
    
    Dim lErr As Long
    
    lErr = cTapi1.LineDrop()
    
    If lErr > 0 Then
        txtResults.Text = txtResults.Text & Time & ":LineDrop:Success." & vbCrLf
    Else
        txtResults.Text = txtResults.Text & Time & ":LineDrop Error:" & lErr & vbCrLf
    End If

End Sub

Private Sub cmdFileDetails_Click()
    
    'Get the wav file details
    
    'Check if the audio wave file exists:
    If Dir(txtAudioFile.Text) = "" Then
        MsgBox "The audio file " & txtAudioFile.Text & " doesn't exists", vbInformation
        Exit Sub
    End If
    
    'Get an information about
    'the PCM wave file:
    
    Dim rc As Long
    Dim WaveFileInfo As WaveFileDetails
    rc = cWave1.GetDetailsWaveFile(txtAudioFile.Text, WaveFileInfo)
    
    txtResults.Text = txtResults.Text & Time & ":" & vbCrLf
    txtResults.Text = txtResults.Text & "FileName: " & WaveFileInfo.FileName & vbCrLf
    txtResults.Text = txtResults.Text & "FilePath: " & WaveFileInfo.FilePath & vbCrLf
    txtResults.Text = txtResults.Text & "FileLen: " & FileLen(txtAudioFile.Text) & vbCrLf
    txtResults.Text = txtResults.Text & "SecondsLength: " & WaveFileInfo.SecondsLength & vbCrLf
    txtResults.Text = txtResults.Text & "cbSize: " & WaveFileInfo.cbSize & vbCrLf
    txtResults.Text = txtResults.Text & "wFormatTag: " & WaveFileInfo.wFormatTag & vbCrLf
    txtResults.Text = txtResults.Text & "nAvgBytesPerSec: " & WaveFileInfo.nAvgBytesPerSec & vbCrLf
    txtResults.Text = txtResults.Text & "nBlockAlign: " & WaveFileInfo.nBlockAlign & vbCrLf
    txtResults.Text = txtResults.Text & "nChannels: " & WaveFileInfo.nChannels & vbCrLf
    txtResults.Text = txtResults.Text & "nSamplesPerSec: " & WaveFileInfo.nSamplesPerSec & vbCrLf
    txtResults.Text = txtResults.Text & "wBitsPerSample: " & WaveFileInfo.wBitsPerSample & vbCrLf

End Sub

Private Sub cmdGenerateDigits_Click()
    
    'Generate digits
    
    Dim lErr As Long
    
    lErr = cTapi1.LineGenerateDigits(txtDigitsToGenerate)
    
    If lErr <> 0 Then
        txtResults.Text = txtResults.Text & Time & ":Generate Digits Error:" & Combo1.List(Combo1.ListIndex) & " (" & cTapi1.GetTapiStrError(lErr) & ")" & vbCrLf
    Else
        txtResults.Text = txtResults.Text & Time & ":Generate Digits " & txtDigitsToGenerate & " is success." & vbCrLf
    End If

End Sub

Private Sub cmdLineInfo_Click()
    
    'Get line info
    
    Dim LineDev As LineDevCap
    
    'Set the line index to get the results for:
    cTapi1.LineIndex = Combo1.ListIndex
    
    'Get the device index to the LineDev:
    cTapi1.LineGetDevDetails LineDev
    
    'Display the results:
    txtResults = txtResults & Time & ":" & vbCrLf _
                & "Device Name:" & LineDev.DeviceName & vbCrLf _
                & "Tapi Capability: " & LineDev.TapiCapability & vbCrLf _
                & "Max Rate: " & LineDev.MaxRate & vbCrLf _
                & "Support Monitor Digits: " & LineDev.MonitorDigits & vbCrLf _
                & "Support Generate Digits: " & LineDev.GenerateDigits & vbCrLf _
                & "Data Mode:" & LineDev.MediaDatamodem & vbCrLf _
                & "Interactivevoice:" & LineDev.MediaInteractivevoice & vbCrLf _
                & "Auto Voice:" & LineDev.MediaAutomatedvoice & vbCrLf _
                & "IsOpened:" & cTapi1.IsLineOpen & vbCrLf _
                & "IsConnected:" & cTapi1.LineIsConnected & vbCrLf
    
                txtResults = txtResults & vbCrLf
            
End Sub

Private Sub cmdLocInfo_Click()
    
    'Get the country code:
    txtResults.Text = txtResults & "Local country Code:" & cTapi1.GetCountryCode & vbCrLf
    
    'Get the city code:
    txtResults.Text = txtResults & "Local city Code:" & cTapi1.GetCityCode & vbCrLf

End Sub

Private Sub cmdLocProp_Click()
    
    cTapi1.LineTranslateDialog

End Sub

Private Sub cmdMonitorDigit_Click()

    'Monitor digits (to the MonitorDigit event)
    
    Dim lErr As Long
    
    lErr = cTapi1.LineMonitorDigits(True)
    
    If lErr <> 0 Then
        txtResults.Text = txtResults.Text & Time & ":LineMonitorDigits Error: " & cTapi1.GetTapiStrError(lErr) & vbCrLf
    Else
        txtResults.Text = txtResults.Text & Time & ":LineMonitorDigits:Success." & vbCrLf
    End If

End Sub

Private Sub cmdNumOfPhones_Click()
    
    'Number of installed phone devices
    
    'Pleas note:
    'This function may not support a standard
    '56k voice modem (phone device only).
    
    cTapi1.PhoneInitialize
    MsgBox cTapi1.NumOfPhones

End Sub

Private Sub cmdOff_Click()

    'Close the line
    
    Dim lErr As Long
    
    'Close the line device
    lErr = cTapi1.LineClose()
    
    If lErr <> 0 Then
        txtResults.Text = txtResults.Text & Time & ":LineClose Error:" & Combo1.List(Combo1.ListIndex) & " (" & cTapi1.GetTapiStrError(lErr) & ")" & vbCrLf
    Else
       txtResults.Text = txtResults.Text & Time & ":Close " & Combo1.List(Combo1.ListIndex) & " is success." & vbCrLf
    End If
    
    'Shutdown the line
    lErr = cTapi1.LineShutdown()
    If lErr <> 0 Then
        txtResults.Text = txtResults.Text & Time & ":LineShutdown Error:" & Combo1.List(Combo1.ListIndex) & " (" & cTapi1.GetTapiStrError(lErr) & ")" & vbCrLf
    Else
       txtResults.Text = txtResults.Text & Time & ":Shutdown " & Combo1.List(Combo1.ListIndex) & " is success." & vbCrLf
    End If

End Sub

Private Sub cmdOn_Click()
    
    'Open the line device
    
    Dim lErr As Long

    'Set the line index:
    cTapi1.LineIndex = Combo1.ListIndex

    'Open the line for in/out calls:
    lErr = cTapi1.LineOpen(LINECALLPRIVILEGE_OWNER _
    , LINEMEDIAMODE_AUTOMATEDVOICE)
    
    
    'For data mode:
    'lErr = cTapi1.LineOpen(LINECALLPRIVILEGE_OWNER _
    , LINEMEDIAMODE_DATAMODEM)
    
    'Check the results:
    If lErr <> 0 Then
        txtResults.Text = txtResults.Text & Time & ":Error open:" & Combo1.List(Combo1.ListIndex) & " (" & cTapi1.GetTapiStrError(lErr) & ")" & vbCrLf
    Else
        txtResults.Text = txtResults.Text & Time & ":LineOpen " & Combo1.List(Combo1.ListIndex) & " success." & vbCrLf
    End If

End Sub

Private Sub cmdOpenPhone_Click()

    'Open phone device
    
    'Pleas note:
    'This function may not support a standard
    '56k voice modem (phone device only).
        
    Dim lErr As Long
    
    'Set the phone device index:
    cTapi1.PhoneIndex = Combo1.ListIndex
    
    'Open the phone device:
    lErr = cTapi1.PhoneOpen()
    
    If lErr <> 0 Then
        txtResults.Text = txtResults.Text & Time & ":Cannot open " & Combo1.List(Combo1.ListIndex) & " as a phone device(" & cTapi1.GetTapiStrError(lErr) & ")" & vbCrLf
    Else
        txtResults.Text = txtResults.Text & Time & ":Open " & Combo1.List(Combo1.ListIndex) & " as a phone device success." & vbCrLf
    End If

End Sub

Private Sub cmdClosePhone_Click()

    'Close the phone device
    
    Dim lErr As Long
    
    lErr = cTapi1.PhoneShutdown
    
    If lErr <> 0 Then
        txtResults.Text = txtResults.Text & cTapi1.GetTapiStrError(lErr) & vbCrLf
    Else
        txtResults.Text = txtResults.Text & Time & ":Close " & Combo1.List(Combo1.ListIndex) & " as a phone device" & vbCrLf
    End If

End Sub

Private Sub cmdPauseIn_Click()
    
    'Pause record
    
    cWave1.RecordPause
    txtResults.Text = txtResults.Text & Time & ": RecordPause." & vbCrLf

End Sub

Private Sub cmdPauseOut_Click()

    'Pause play
    
    cWave1.PlayPause
    txtResults.Text = txtResults.Text & Time & ": PlayPause." & vbCrLf

End Sub

Private Sub cmdPlay_Click()

    'Check if the audio wave file exists:
    If Dir(txtAudioFile.Text) = "" Then
        MsgBox "The audio file " & txtAudioFile.Text & " doesn't exists", vbInformation
        Exit Sub
    End If
    
    'Error handle:
    Dim rc As Long
    
    'The sound device (modem/phone card) to play to:
    Dim lSoundDeviceIndex As Long
    
    If cWave1.IsPlaying Then Exit Sub
    
    'Get the size of the wave file to
    'be play:
    Dim WaveFileInfo As WaveFileDetails
    rc = cWave1.GetDetailsWaveFile(txtAudioFile.Text, WaveFileInfo)
    
    'Start to play the PCM wave file to
    'a specific device (as sound card,
    'modem, etc..)
    
    'Get the line index to play to:
    lSoundDeviceIndex = cTapi1.lineGetID(VB6Tapi.DEVICECLASS.WAVEOUT)
    
    rc = cWave1.PlayStart(txtAudioFile.Text, lSoundDeviceIndex, 8000)
    If rc <> 0 Then
        txtResults.Text = txtResults.Text & Time & ": Error Play Start:" & cWave1.WaveOutErrText(rc) & vbCrLf
        Exit Sub
    End If
    
    'Get the time from seconds to
    'somthing like: 01:48:16
    lbTotalLengthSec.Caption = cWave1.GetSecondsAsTimeString(WaveFileInfo.SecondsLength)
    
    tmSlider.Enabled = True
    txtResults.Text = txtResults.Text & vbCrLf & Time & ": PlayeStart Success." & vbCrLf
    cmdFileDetails.Enabled = False

End Sub

Private Sub cmdRecord_Click()
    
    'The sound device (modem/phone card) to record from
    Dim lSoundDeviceIndex As Long
    
    'Error handling
    Dim rc As Long
    
    '**************************************
    'Do not save the silence section at
    'the end of the recording process:
    If chkCutSilence.Value = vbChecked Then
        cWave1.CutSilence = True
        cWave1.CutSilenceVal = 20
        txtResults.Text = txtResults.Text & Time & ": CutSilence=True, Val=20." & vbCrLf
    End If
    
    'Silence/voice detection:
    If chkMeterIn.Value = vbChecked Then
        cWave1.MeterIn = True
        txtResults.Text = txtResults.Text & Time & ": MeterIn=True." & vbCrLf
    End If
    
    '**************************************
    'Pre screen the sound buffers
    'to a different sound device:
    Dim lToDeviceIndex As Long
    
    'To the sound card device:
    lToDeviceIndex = 0
    
    'Pre screen check:
    If chkPreScreen.Value = vbChecked Then
        cWave1.PreScreenOpen WaveFormat_PCM, lToDeviceIndex
        txtResults.Text = txtResults.Text & Time & ": PreScreenOpen." & vbCrLf
    Else
       cWave1.PreScreenClose
       txtResults.Text = txtResults.Text & Time & ": PreScreenClose." & vbCrLf
    End If
           
    '**************************************
    'Get the line index of the device for recording:
    lSoundDeviceIndex = cTapi1.lineGetID(VB6Tapi.DEVICECLASS.WAVEIN)
    
    'Start record:
    rc = cWave1.RecordStart(lSoundDeviceIndex, txtAudioFile.Text, _
    WaveFormat_PCM, _
    1600)
    
    'Check if an error appears:
    If rc <> 0 Then
        txtResults.Text = txtResults.Text & Time & ": Error RecordStart ." & cWave1.WaveOutErrText(rc) & vbCrLf
        Exit Sub
    End If
    
    txtResults.Text = txtResults.Text & Time & ": RecordStart Success." & vbCrLf
    
    cmdFileDetails.Enabled = False
    chkCutSilence.Enabled = False
    
End Sub

Private Sub cmdSetTerm_Click()

    Dim lErr As Long
    
    lErr = cTapi1.PhoneSetHookSwitch(PHONEHOOKSWITCHDEV_SPEAKER, PHONEHOOKSWITCHMODE_MICSPEAKER)
    
    If lErr <> 0 Then
        txtResults.Text = txtResults.Text & Time & ":Error PhoneSetHookSwitch:" & cTapi1.GetTapiStrError(lErr) & vbCrLf
    Else
        txtResults.Text = txtResults.Text & Time & ":PhoneSetHookSwitch " & Combo1.List(Combo1.ListIndex) & vbCrLf
    End If

End Sub

Private Sub cmdStop_Click()
    
    'Stop play
    
    Dim rc As Long
    
    'Stop to play
    
    rc = cWave1.PlayStop
    If rc <> 0 Then
        txtResults.Text = txtResults.Text & Time & ": Error PlayStop ." & cWave1.WaveOutErrText(rc) & vbCrLf
    End If
    
    'Reset the controls
    tmSlider.Enabled = False
    cSlider1.Value = 0
    
    txtResults.Text = txtResults.Text & Time & ": PlayStop Success." & vbCrLf

End Sub

Private Sub cmdStopRec_Click()

    'Stop to record:
    
    cWave1.RecordStop
    txtResults.Text = txtResults.Text & Time & ": RecordStop Success." & vbCrLf

End Sub

Private Sub cmdUnPauseIn_Click()
    
    'Unpuase record
    
    If cWave1.IsPausedIn Then
        cWave1.RecordUnPause
        txtResults.Text = txtResults.Text & Time & ": RecordUnPause." & vbCrLf
    End If

End Sub

Private Sub cmdUnPauseOut_Click()

    'UnPause play
    
    cWave1.PlayUnPause
    txtResults.Text = txtResults.Text & Time & ": PlayUnPause." & vbCrLf

End Sub

Private Sub cWave1_DonePlay()

    'Done play
    
    txtResults.Text = txtResults.Text & Time & ": DonePlay Event." & vbCrLf
    
    cmdFileDetails.Enabled = True

End Sub

Private Sub cWave1_DoneRecord()

    'Done record
    
    txtResults.Text = txtResults.Text & Time & ": DoneRecord Event." & vbCrLf
    
    chkCutSilence.Enabled = True
    cmdFileDetails.Enabled = True

End Sub

Private Sub cWave1_InMeter(Meter As Integer)

    'Display the buffers meter (from 0 to 120)
    
    prgMeter.Value = Meter

End Sub

Private Sub Form_Load()
    
    Dim LineIndex As Long
    Dim sDeviceName As String
    Dim LineDev As LineDevCap
    Dim lErr As Long
    
    '*******************************************************
    'TAPI
    '*******************************************************
    'Init the TAPI control, must be call before
    'using any functionlity of the control.
    'sKey = Your lisence key, on the trial
    'version, use the "Trial Mode." string:
    cTapi1.Init "Trial Mode."
    
    'First, init the TAPI environment:
    lErr = cTapi1.LineInitialize
    If lErr <> 0 Then
        MsgBox "Con't Init Tapi:" & cTapi1.GetTapiStrError(lErr)
        Exit Sub
    End If
    
    'Scan all the lines and get the device name:
    For LineIndex = 0 To cTapi1.NumOfLines - 1
        
        'Get device details by the index
        cTapi1.LineIndex = LineIndex
        cTapi1.LineGetDevDetails LineDev
        sDeviceName = LineDev.DeviceName
        
        'Add to the list DeviceName and DeviceIndex.
        Combo1.AddItem sDeviceName
        
    Next LineIndex
    
    'Combo1.ListIndex = 0
    
    '*******************************************************
    'Audio
    '*******************************************************
    'Init the audio control, must be call before
    'using any functionlity of the control.
    'sKey = Your lisence key, on the trial
    'version, use the "Trial Mode." string:
    cWave1.Init "Trial Mode."
    
    'Set the wave format for recording
    'and pre-screen, this sample use
    'a standard voice modem tags format:
    WaveFormat_PCM.wFormatTag = WAVE_FORMAT_PCM
    WaveFormat_PCM.nChannels = 1
    WaveFormat_PCM.wBitsPerSample = 16
    WaveFormat_PCM.nSamplesPerSec = 8000 ' 8000 '32000 11025 '
    WaveFormat_PCM.nBlockAlign = WaveFormat_PCM.nChannels * (WaveFormat_PCM.wBitsPerSample / 8)
    WaveFormat_PCM.nAvgBytesPerSec = WaveFormat_PCM.nSamplesPerSec * WaveFormat_PCM.nBlockAlign
    WaveFormat_PCM.cbSize = 0
    
    'Unable all the audio control
    'while a call doesn't  exists:
    SetAudioEnable False
    
    'Default audio location:
    txtAudioFile.Text = App.Path & "\wav-file.wav"
    
    

End Sub

Private Sub SetAudioEnable(bVal As Boolean)
    
    'Enable/Disable audio controls
    
    If bVal = True Then
        chkMeterIn.Enabled = True
        chkPreScreen.Enabled = True
        chkCutSilence.Enabled = True
        cmdRecord.Enabled = True
        cmdStopRec.Enabled = True
        cmdPauseIn.Enabled = True
        cmdUnPauseIn.Enabled = True
        prgMeter.Enabled = True
        cSlider1.Enabled = True
        cmdPlay.Enabled = True
        cmdStop.Enabled = True
        cmdPauseOut.Enabled = True
        cmdUnPauseOut.Enabled = True
        txtAudioFile.Enabled = True
    Else
        chkMeterIn.Enabled = False
        chkPreScreen.Enabled = False
        chkCutSilence.Enabled = False
        cmdRecord.Enabled = False
        cmdStopRec.Enabled = False
        cmdPauseIn.Enabled = False
        cmdUnPauseIn.Enabled = False
        prgMeter.Enabled = False
        cSlider1.Enabled = False
        cmdPlay.Enabled = False
        cmdStop.Enabled = False
        cmdPauseOut.Enabled = False
        cmdUnPauseOut.Enabled = False
        txtAudioFile.Enabled = False
    End If

End Sub

Private Sub Form_Unload(Cancel As Integer)
    
    'Check if the line is open.
    If cTapi1.IsLineOpen Then cTapi1.LineShutdown
    
    'Check if the phone device is open.
    If cTapi1.IsPhoneOpen Then cTapi1.PhoneShutdown
    
    'Release the control
    cTapi1.DeInit
    
    'Release the control:
    cWave1.DeInit

End Sub

Private Sub TimerProg_Timer()
    
    'Move the slider:
    cSlider1.Value = cWave1.GetPositionSlider
    lblCurrentPositionSec.Caption = cWave1.GetSecondsAsTimeString(cWave1.GetPositionSeconds)

End Sub

Private Sub tmSlider_Timer()
    
    'Move the slider:
    cSlider1.Value = cWave1.GetPositionSlider
    lblCurrentPositionSec.Caption = cWave1.GetSecondsAsTimeString(cWave1.GetPositionSeconds)

End Sub

Private Sub txtResults_Change()
    
    On Error Resume Next
    
    txtResults.SelStart = Len(txtResults.Text) - 1

End Sub

'*************************************************************
'TAPI Events
'*************************************************************
Private Sub cTapi1_CallerID(ByVal CallerName As String, ByVal CallerNumber As String)

    txtResults = txtResults & "Caller name:" & CallerName & " Caller number:" & CallerNumber & " in line index: " & cTapi1.LineIndex & vbCrLf

End Sub

Private Sub cTapi1_Connected()

    txtResults = txtResults & "The call in line index:" & cTapi1.LineIndex & " is connected" & vbCrLf
    
    'Able the audio controls:
    SetAudioEnable True

End Sub

Private Sub cTapi1_Dialing()

    txtResults = txtResults & "Dialing '" & txtPhoneNum & "' in line index:" & cTapi1.LineIndex & vbCrLf

End Sub

Private Sub cTapi1_Disconnected()

    txtResults = txtResults & "Disconnected call in line index:" & cTapi1.LineIndex & vbCrLf
    
    'Unable the audio controls:
    SetAudioEnable False

End Sub

Private Sub cTapi1_DoneGenerateDigits()
    
    txtResults = txtResults & "Done generate the '" & txtDigitsToGenerate & "' digits in line index" & cTapi1.LineIndex & vbCrLf

End Sub

Private Sub cTapi1_Idle()

    txtResults = txtResults & "Idel call in line index:" & cTapi1.LineIndex & vbCrLf
    
    'Unable the audio controls:
    SetAudioEnable False

End Sub

Private Sub cTapi1_IncomingCall()
    
    txtResults = txtResults & "Incoming call in line index:" & cTapi1.LineIndex & vbCrLf

End Sub

Private Sub cTapi1_MonitorDigit(ByVal Digit As String)
    
    txtResults = txtResults & "Digit:" & Digit & " Line index:" & cTapi1.LineIndex & vbCrLf

End Sub

Private Sub cTapi1_ProcNumber(ByVal ProcNumber As Long, ByVal ResultNumber As Long)
    'Raise when an asynchronous function returns a value
    
    txtResults = txtResults & cTapi1.LineIndex & " From process number" & ProcNumber & ResultNumber & vbCrLf

End Sub

Private Sub cTapi1_Ring(ByVal RingNumber As Long)

    txtResults = txtResults & "Ring:" & RingNumber & _
    "  Line index:" & cTapi1.LineIndex & vbCrLf

End Sub

