rem This script registers the OCX file with regsvr32 on the local system of windows.

@echo off

rem Set the name of the OCX file to register
set file=Component\VB6Tapi.ocx

rem Set the "file" variable to the full path of the OCX file in the same directory as the batch file
set file=%~dp0\%file%

rem Display a message indicating that the OCX file is being registered
echo Registering %file%...

rem Register the OCX file with regsvr32 and suppress any output
regsvr32 /s %file% >nul 2>&1

rem Check the error level returned by regsvr32
if %errorlevel% neq 0 (
  rem Display an error message and exit with the same error level
  echo An error occurred while registering %file%. Error code: %errorlevel%.
  pause
  exit /b %errorlevel%
)

rem Display a message indicating that the registration process completed successfully
echo Registration of %file% completed successfully.

rem Pause the script to allow the user to view the output
pause
